<?php
/****************************************
 * XKLog 后台管理页
 *
 * 此文件控制输出后台管理页
 *
 * 更新：2009-06-23
 * 版本：V1.0
 ****************************************/

require('../include/loader.php');
@header("content-Type: text/html; charset=utf-8");

if( !user_is_super_admin() ){
	//SafeLogger("试图直接访问后台页面 admin_recyled.php 。")
	//SafeDefender()
	show_admin_message( '您尚未登录，或者登录已过期' );
	exit;
}

$action = getGP( 'action', 'G' );

switch( $action ) {
	case 'BatchArticleExe':
	    batch_exe( 'article' );
		break;
	case 'BatchCommentExe':
	    batch_exe( 'comment' );
		break;
	case 'BatchUserExe':
		batch_exe( 'user' );
		break;
	case 'BatchLinkExe':
		batch_exe( 'link' );
		break;
}

function batch_exe( $type ) {
	show_admin_message( '抱歉，此功能尚未完成', get_http_referer() );
	exit;
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns = "http://www.w3.org/1999/xhtml" lang = "zh-cn">
<head>
	<meta http-equiv = "Content-Type" content = "text/html; charset=UTF-8" />
	<meta http-equiv = "Content-Language" content = "UTF-8" />
	<title><?php echo $_CACHE['set'][0]['BlogName'] ?> - 后台管理</title>
	<link rel = "stylesheet" type = "text/css" href = "../Include/Style.css" />
	<style type="text/css">
	.style1 {font-size: 12px}
	.style3 {font-size: 12px;font-weight: bold;}
	</style>
	<script language="javascript" type="text/javascript" src="../Include/admin.js"></script>
</head>
<body id = "Admin_Body">
<div id = "Admin_Main">
<center>

	<div class = "Admin_Panel">
		<div class = "Admin_Title">回收站</div>
		<div class = "Admin_Content">
			<div style="padding:5px;margin:2px;border:1px solid #96C2F1;background-color: #EFF7FF;"><a href="admin_recyled.php?action=Article">日志</a> | <a href="admin_recyled.php?action=Comment">评论</a> | <a href="admin_recyled.php?action=User">用户</a> | <a href="admin_recyled.php?action=Link">链接</a></div>
<?php

switch( $action ) {
	case 'Article':
	    article_list();
		break;
	case 'BatchArticle':
	    article_list( 'batch' );
		break;
	case 'Comment':
	    comment_list();
		break;
	case 'BatchComment':
	    comment_list( 'batch' );
		break;
	case 'User':
	    user_list();
		break;
	case 'BatchUser':
	    user_list( 'batch' );
		break;
	case 'Link':
		link_list();
		break;
	case 'BatchLink':
		link_list( 'batch' );
		break;
	default:
		main();
}

function article_list( $action = 'list' ) {
	global $db,$_CACHE;
	if( $action == 'batch' ) {
		$id_arr = array();
		$id_arr = getGP( 'id_arr','P','array' );
		$control = getGP( 'Control','P' );
		$size = count( $id_arr );
		if( $size == 0 ) {
			obclean();
			show_admin_message( '您没有选中任何日志', 'admin_recyled.php?action=Article' );
			exit;
		}
		$sql = '';
		for( $i=0; $i<$size; $i ++ ){
			$sql .= 'ID=' . $id_arr[$i] . ' OR ';
		}
		$sql = substr( $sql,0,-4 );
		$sql = 'select ID,Author,Title,Time,IsDel,Category,`Read`,Comment,`Type` from `' . PREFIX_STR . 'Article` where IsDel=1 AND (' . $sql . ') order by ID desc';
	}else{
		$sql = 'select ID,Author,Title,Time,IsDel,Category,`Read`,Comment,`Type` from `' . PREFIX_STR . 'Article` where IsDel=1 order by ID desc';
	}
	$article_array = $db->fetch_all( $sql );
?>
			<?php if( $action == 'list' ) { ?><form name="smslist" action="admin_recyled.php?action=BatchArticle" method="post"><?php } ?>
				<div style="padding:5px;margin:2px;">      
					<table <?php if( $action == 'list' ) { ?>class="pickme"<?php } ?> style="table-layout: fixed;word-wrap: break-word;" width="100%" border="0" cellpadding="0" cellspacing="1" bgcolor="b5d6e6" onmouseover="changeto()"  onmouseout="changeback()">
						<thead>
							<tr align="center" height="22" bgcolor="#ffffff">
								<td width="3%"  background="../Include/bg.gif"><?php if( $action == 'list' ) { ?><input type="checkbox" name="allbox" onclick="CheckAll();"><input type="checkbox" id="ckbox" style="display:none;" disabled><?php } ?></td>
								<td width="3%"  background="../Include/bg.gif">序号</td>
								<td width="10%" background="../Include/bg.gif">作者</td>
								<td width="26%" background="../Include/bg.gif">标题</td>
								<td width="6%" background="../Include/bg.gif">类型</td>
								<td width="8%" background="../Include/bg.gif">分类</td>
								<td width="8%" background="../Include/bg.gif">阅读</td>
								<td width="8%" background="../Include/bg.gif">评论</td>
								<td width="15%" background="../Include/bg.gif">时间</td>
								<td width="13%" background="../Include/bg.gif">管理操作</td>
							</tr>
						</thead>
						<tbody>
							<?php
							$i = 1;
							foreach( $article_array as $value ) {
							?>
							<tr align="center" height="20" bgcolor="#ffffff">
								<td ><?php if( $action == 'list' ) { ?><input type="checkbox" id="ckbox" name="id_arr[]" value="<?php echo $value['ID'] ?>" /><?php } ?></td>
								<td><?php echo $i ?></td>
								<td><?php echo $value['Author'] ?></td>
								<td align="left"><?php echo $value['Title'] ?></td>
								<td><?php echo $value['Type'] ?></td>
								<td><?php echo $_CACHE['category'][$value['Category']]['Name'] ?></td>
								<td><?php echo $value['Read'] ?></td>
								<td><?php echo $value['Comment'] ?></td>
								<td><?php echo date( 'Y-m-d', $value['Time'] ) ?></td>
								<td><?php if( $action == 'list' ) { ?><img src="../Include/edt.gif" width="16" height="16" /><span class="Control"><a href="">恢复</a>&nbsp; &nbsp;<img src="../Include/del.gif" width="16" height="16" /><a href="javascript:if(confirm('确实要删除吗?'))location=''">删除</a></span><?php } ?></td>
							</tr>
							<?php
								$i ++;
							}
							?>
						</tbody>
					</table>
				</div>
			<?php if( $action == 'list' ) { ?>
				<div align="center">批量管理选项: <input type="radio" name="Control" value="删除" checked="checked"/>删除 <input type="radio" name="Control" value="恢复" />恢复 <input type="submit" name="functionmit" class="Main_Button" value="执行操作" /></div>
			<?php }else{ ?>
				<div style="padding:5px;margin:2px;">
				<form name="smslist" action="admin_recyled.php?action=BatchArticleExe" method="post">
				<?php
					if( $control == '删除' ) {
				?>
					<input type="hidden" name="Control" value="删除"/>
					<b>彻底删除后将不可恢复！确认要删除吗？</b><br />
					<input type="submit" name="submit" class="Main_Button" value="确认删除" />
				<?php
					}else{
				?>
					<input type="hidden" name="Control" value="恢复"/>
					<input type="submit" name="submit" class="Main_Button" value="确认恢复" />
				<?php
					}
				?>
				</form>
				</div>
			<?php } ?>
			<?php if( $action == 'list' ) { ?></form><?php } ?>
<?php
}

function comment_list( $action = 'list' ) {
	global $db,$_CACHE;
	if( $action == 'batch' ) {
		$id_arr = array();
		$id_arr = getGP( 'id_arr','P','array' );
		$control = getGP( 'Control','P' );
		$size = count( $id_arr );
		if( $size == 0 ) {
			obclean();
			show_admin_message( '您没有选中任何评论', 'admin_recyled.php?action=Comment' );
			exit;
		}
		$sql = '';
		for( $i=0; $i<$size; $i ++ ){
			$sql .= 'CID=' . $id_arr[$i] . ' OR ';
		}
		$sql = substr( $sql,0,-4 );
		$sql = 'select CID,Author,Time,Comment,Reply,ReplyTime from `' . PREFIX_STR . 'Comment` where IsDel=1 AND (' . $sql . ') order by CID desc';
	}else{
		$sql = 'select CID,Author,Time,Comment,Reply,ReplyTime from `' . PREFIX_STR . 'Comment` where IsDel=1 order by CID desc';
	}
	$comment_array = $db->fetch_all( $sql );
?>
			<?php if( $action == 'list' ) { ?><form name="smslist" action="admin_recyled.php?action=BatchComment" method="post"><?php } ?>
				<div style="padding:5px;margin:2px;">      
					<table <?php if( $action == 'list' ) { ?>class="pickme"<?php } ?> style="table-layout: fixed;word-wrap: break-word;" width="100%" border="0" cellpadding="0" cellspacing="1" bgcolor="b5d6e6" onmouseover="changeto()"  onmouseout="changeback()">
						<thead>
							<tr align="center" height="22" bgcolor="#ffffff">
								<td width="3%"  background="../Include/bg.gif"><?php if( $action == 'list' ) { ?><input type="checkbox" name="allbox" onclick="CheckAll();"><input type="checkbox" id="ckbox" style="display:none;" disabled><?php } ?></td>
								<td width="3%"  background="../Include/bg.gif">序号</td>
								<td width="10%" background="../Include/bg.gif">作者</td>
								<td width="31%" background="../Include/bg.gif">内容</td>
								<td width="9%" background="../Include/bg.gif">时间</td>
								<td width="22%" background="../Include/bg.gif">回复</td>
								<td width="9%" background="../Include/bg.gif">回复时间</td>
								<td width="13%" background="../Include/bg.gif">管理操作</td>
							</tr>
						</thead>
						<tbody>
							<?php
							$i = 1;
							foreach( $comment_array as $value ) {
							?>
							<tr align="center" height="20" bgcolor="#ffffff">
								<td ><?php if( $action == 'list' ) { ?><input type="checkbox" id="ckbox" name="id_arr[]" value="<?php echo $value['CID'] ?>" /><?php } ?></td>
								<td><?php echo $i ?></td>
								<td><?php echo $value['Author'] ?></td>
								<td align="left"><?php echo $value['Comment'] ?></td>
								<td><?php echo date( 'Y-m-d', $value['Time'] ) ?></td>
								<td align="left"><?php echo $value['Reply'] ?></td>
								<td><?php if( $value['Reply'] != '' ) echo date( 'Y-m-d', $value['ReplyTime'] ); ?>
								</td>
								<td><?php if( $action == 'list' ) { ?><img src="../Include/edt.gif" width="16" height="16" /><span class="Control"><a href="Admin_Censor.asp?action=GOK&id=<?php echo $value['CID'] ?>">恢复</a>&nbsp; &nbsp;<img src="../Include/del.gif" width="16" height="16" /><a href="javascript:if(confirm('确实要删除吗?'))location='Admin_Censor.asp?action=GDel&id=<?php echo $value['CID'] ?>'">删除</a></span><?php } ?></td>
							</tr>
							<?php
								$i ++;
							}
							?>
						</tbody>
					</table>
				</div>
			<?php if( $action == 'list' ) { ?>
				<div align="center">批量管理选项: <input type="radio" name="Control" value="删除" checked="checked"/>删除 <input type="radio" name="Control" value="恢复" />恢复 <input type="submit" name="Submit" class="Main_Button" value="执行操作" /></div>
			<?php }else{ ?>
				<div style="padding:5px;margin:2px;">
				<form name="smslist" action="admin_recyled.php?action=BatchCommentExe" method="post">
				<?php
					if( $control == '删除' ) {
				?>
					<input type="hidden" name="Control" value="删除"/>
					<b>彻底删除后将不可恢复！确认要删除吗？</b><br />
					<input type="submit" name="submit" class="Main_Button" value="确认删除" />
				<?php
					}else{
				?>
					<input type="hidden" name="Control" value="恢复"/>
					<input type="submit" name="submit" class="Main_Button" value="确认恢复" />
				<?php
					}
				?>
				</form>
				</div>
			<?php } ?>
			<?php if( $action == 'list' ) { ?></form><?php } ?>
<?php
}

function user_list() {
	global $db,$_CACHE;
	$sql = "select * from `" . PREFIX_STR . "User` where IsDel=1";
	$user_array = $db->fetch_all( $sql );
?>
			<form name="smslist" action="admin_recyled.php?action=BatchUser" method="post">
				<div style="padding:5px;margin:2px;">
					<table class="pickme" style="table-layout: fixed;word-wrap: break-word;" width="100%" border="0" cellpadding="0" cellspacing="1" bgcolor="b5d6e6" onmouseover="changeto()"  onmouseout="changeback()">
						<thead>
							<tr align="center" height="22" bgcolor="#ffffff">
								<td width="3%"  background="../Include/bg.gif"><input type="checkbox" name="allbox" onclick="CheckAll();"><input type="checkbox" id="ckbox" style="display:none;" disabled></td>
								<td width="3%"  background="../Include/bg.gif">序号</td>
								<td width="10%" background="../Include/bg.gif">用户名</td>
								<td width="10%" background="../Include/bg.gif">用户组</td>
								<td width="15%" background="../Include/bg.gif">电子邮箱</td>
								<td width="10%" background="../Include/bg.gif">Q Q</td>
								<td width="13%" background="../Include/bg.gif">主页</td>
								<td width="10%" background="../Include/bg.gif">上次登录IP</td>
								<td width="13%" background="../Include/bg.gif">上次登录时间</td>
								<td width="13%" background="../Include/bg.gif">管理操作</td>
							</tr>
						</thead>
						<tbody>
							<?php
							$i = 1;
							foreach( $user_array as $value ) {
							?>
							<tr align="center" height="20" bgcolor="#ffffff">
								<td ><input type="checkbox" id="ckbox" name="id_arr[]" value="<?php echo $value['UID'] ?>" /></td>
								<td><?php echo $i ?></td>
								<td><?php echo $value['UserName'] ?></td>
								<td><?php if( $value['Group'] > 7 ) { echo '管理员'; }else{ echo '注册用户'; } ?></td>
								<td><?php echo $value['Email'] ?></td>
								<td><?php if( $value['QQNum'] == 0 ) { echo ''; }else{ echo $value['QQNum']; } ?></td>
								<td><?php echo $value['Index'] ?></td>
								<td><?php echo $value['IP'] ?></td>
								<td><?php echo date('Y-m-d',$value['Time']) ?></td>
								<td><img src="../Include/edt.gif" width="16" height="16" /><span class="Control"><a href="admin_recyled.php?action=RecoverUser&id=<?php echo $value['UID'] ?>">恢复</a>&nbsp; &nbsp;<img src="../Include/del.gif" width="16" height="16" /><a href="javascript:if(confirm('确实要删除吗?'))location='admin_recyled.php?action=DelUser&id=<?php echo $value['UID'] ?>'">删除</a></span></td>
							</tr>
								<?php
								$i ++;
							}
							?>
						</tbody>
					</table>
				</div>
				<div align="center">批量管理选项: <input type="radio" name="Control" value="删除" checked="checked"/>删除 <input type="radio" name="Control" value="恢复" />恢复 <input type="submit" name="Submit" class="Main_Button" value="执行操作" /></div>
				<div class="Main_Button"></div>
			</form>
<?php
}

function link_list( $action = 'list' ) {
	global $db,$_CACHE;
	$sql = "select * from `" . PREFIX_STR . "Link` where IsDel=1";
	$link_array = $db->fetch_all( $sql );
?>
			<form name="smslist" action="admin_recyled.php?action=BatchLink" method="post">
				<div style="padding:5px;margin:2px;">      
					<table class="pickme" style="table-layout: fixed;word-wrap: break-word;" width="100%" border="0" cellpadding="0" cellspacing="1" bgcolor="b5d6e6" onmouseover="changeto()"  onmouseout="changeback()">
						<thead>
							<tr align="center" height="22" bgcolor="#ffffff">
								<td width="3%"  background="../Include/bg.gif"><input type="checkbox" name="allbox" onclick="CheckAll();"><input type="checkbox" id="ckbox" style="display:none;" disabled></td>
								<td width="3%"  background="../Include/bg.gif">序号</td>
								<td width="24%" background="../Include/bg.gif">链接名称</td>
								<td width="30%" background="../Include/bg.gif">链接描述</td>
								<td width="27%" background="../Include/bg.gif">链接地址</td>
								<td width="13%" background="../Include/bg.gif">管理操作</td>
							</tr>
						</thead>
						<tbody>
							<?php
							$i = 1;
							foreach( $link_array as $value ) {
							?>
							<tr align="center" height="20" bgcolor="#ffffff">
								<td ><input type="checkbox" id="ckbox" name="id_arr[]" value="<?php echo $value['LID'] ?>" /></td>
								<td><?php echo $i ?></td>
								<td><?php echo $value['Title'] ?></td>
								<td><?php echo $value['Description'] ?></td>
								<td><?php echo $value['Address'] ?></td>
								<td><img src="../Include/edt.gif" width="16" height="16" /><span class="Control"><a href="Admin_Censor.asp?action=GOK&id=<?php echo $value['LID'] ?>">恢复</a>&nbsp; &nbsp;<img src="../Include/del.gif" width="16" height="16" /><a href="javascript:if(confirm('彻底删除后将不可恢复！确实要彻底删除吗?'))location='Admin_Censor.asp?action=GDel&id=<?php echo $value['LID'] ?>'">删除</a></span></td>
							</tr>
							<?php
								$i ++;
							}
							?>
						</tbody>
					</table>
				</div>
				<div align="center">批量管理选项: <input type="radio" name="Control" value="删除" checked="checked"/>删除 <input type="radio" name="Control" value="恢复" />恢复 <input type="submit" name="Submit" class="Main_Button" value="执行操作" /></div>
			</form>
<?php
}

function main() {
?>
			<div style="padding:10px;">      
				欢迎来到 <b>回收站</b>，在这里您可以恢复被删除的日志、评论、链接和用户。
			</div>
<?php
}
?>
			<div class="Main_Button"></div>
		</div>
	</div>

	<div id="Foot"><?php show_run_info() ?></div>
</center>
</div>
</body>
</html>